var currentQuestion = '';
var timeOutHandle = 0;
var wsURL = '';
var action = 'POST';
var wsParams = '';
var requestTimeOut = 10000;
var refreshDelay = 1000;
var ao;

function log(message) {
    var d = new Date();
    debug.log("" + d + " : " + message);
}

function startMonitoring(url, data, question, row) {
    log("Monitoring starting")

    currentQuestion = question;
    wsURL = url;
    wsParams = data;

    log("-- using " + action + " with URL=" + url + "?" + data);

    log("Answer list populate started.");
    parent.fetchAnswers(currentQuestion, row);

    log("Answer list populate completed.");
    log("ASynch refresh starting.");

    fetchEvents();

    log("ASynch refresh started."); 
}

function timeOutHandler() {
    log("!!!! Executing timeOut procedure. !!!!");
    try {
        log("Aborting request.");
        ao.http.abort();
    } catch (e) {
        log("Failed to abort request.");
        //ignore errors
    }
    fetchEvents();
}

function fetchEvents() {
    log("Refresh starting.");
    log("Ajax initializing.");
    ao = new AjaxObject101(); //On failure a new object should be created

    log("Backup timeOut starting.");
    timeOutHandle = setTimeout('timeOutHandler()', requestTimeOut); //Start before sending request in case the request is super fast and fails to cancel the backup.

    log("Setting callback function.");
    ao.funcDone = processEvent; //Gets raised no matter what the HTTP result is... should only be for 200s

    log("Sending " + action + " request.");
    ao.sndReq(action, wsURL, wsParams); //Change to GET should help
    log(action + " request sent.");
}

function processEvent(ao) {
    log("Processing answer. Status=" + ao.http.status);
    try {
        clearRequestTimeOut();
        if (ao.http.status == 200) {
            log("Processing valid response.");
            processResponse(ao);
            log("Response processed successfuly.");
        } else log("!!!! Invalid response from server. Response = " + ao.http.responseText);
    } catch (e) {
        log(e.Message);

    }
    log("Scheduling refresh.");
    timeOutHandle = setTimeout('fetchEvents()', refreshDelay); //Need to process the event before resubmitting
}

function clearRequestTimeOut() {
    if (timeOutHandle != 0) clearTimeout(timeOutHandle); //Clear the request 
}

function processResponse(ao) {
    var events = ao.http.responseText.split('|E|');

    for (var i = 0; i < events.length; i++) {
        var values = events[i].split('||');

        if (values.length == 6) {
            if (values[5] == 'SCROLLTOP') {
                var elem = document.getElementById(values[1]);
                if (elem) {
                    elem.scrollTop = values[3];
                }
            }
            else {
                var questionId = values[0];
                if (currentQuestion != '' && currentQuestion != questionId) {
                    if (questionId == 'interviewTerminated')
                        parent.clearAnswers();
                    else {
                        parent.fetchAnswers(questionId, values[4]);
                    }
                    location.reload(true);
                    return;
                }

                currentQuestion = questionId;

                var input = document.getElementById(values[1]);

                if (values[2] == 'function') {
                    eval(values[3]);
                }
                else
                    if (input != null) {
                        if (values[2] == 'text' || values[2] == 'textarea')
                            input.value = values[3];
                        else {
                            if (values[2] == 'select')
                                input.selectedIndex = values[3];
                            else {
                                if (values[2] == 'radio' || values[2] == 'checkbox') {
                                    if (values[3] == 'true') {
                                        input.checked = true;
                                    }
                                    else {
                                        input.checked = false;
                                    }
                                    // Cause the CATI answer text field to be updated
                                    input.onclick();
                                }
                            }
                        }
                    }
            }
        }
    }
}


function UpdateButtonsState() {
    for (var i = 0; i < document.forms[0].elements.length; i++) {
        var elem = document.forms[0].elements[i];

        if (elem.type == 'button') {
            elem.onclick = 'javascript:void(0);';
        }
    }
}

function onFormSubmit() {
    return false;
}